<?xml version="1.0" encoding="utf-8" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:param name="Local">local</xsl:param>
<xsl:param name="ImgPath">../js</xsl:param>
<xsl:param name="lang">en</xsl:param>
<xsl:param name="toclang">ENGLISH</xsl:param>
<xsl:template match="/">
<!-- Build = 2006.03.22 -->
<html>
<div id="region">
	<div class="ttl0">
		<a href="#">
			<xsl:attribute name="onclick">
				showCover()
			</xsl:attribute>
			<xsl:attribute name="title">
				<xsl:if test="$toclang != 'JAPANESE'">Cover Page</xsl:if>
				<xsl:if test="$toclang = 'JAPANESE'">表紙</xsl:if>
			</xsl:attribute>
			<span style="background:white" class="doccover">
				<xsl:if test="$toclang != 'JAPANESE'">Cover Page</xsl:if>
				<xsl:if test="$toclang = 'JAPANESE'">表紙</xsl:if>
			</span>
		</a>
	</div>
<!--
	<div class="ttl0">
		<a href="#">
			<xsl:attribute name="onclick">
				<xsl:if test="$toclang != 'JAPANESE'">openNewWindow("note/note_sch_en.html", "scrollbars=yes,resizable=yes,menubar=yes,directories=no,status=no,location=no,width=800,height=600")</xsl:if>
				<xsl:if test="$toclang = 'JAPANESE'">openNewWindow("note/note_sch_ja.html", "scrollbars=yes,resizable=yes,menubar=yes,directories=no,status=no,location=no,width=800,height=600")</xsl:if>
			</xsl:attribute>
			<xsl:attribute name="title">
				<xsl:if test="$toclang != 'JAPANESE'">Note on Using Circuit Diagrams</xsl:if>
				<xsl:if test="$toclang = 'JAPANESE'">回路図使用上の注意</xsl:if>
			</xsl:attribute>
			<xsl:if test="$toclang != 'JAPANESE'">Note on Using Circuit Diagrams</xsl:if>
			<xsl:if test="$toclang = 'JAPANESE'">回路図使用上の注意</xsl:if>
		</a>
	</div>
	<div class="ttl0">
		<a href="#">
			<xsl:attribute name="onclick">
				<xsl:if test="$toclang != 'JAPANESE'">openNewWindow("note/note_plist_en.html", "scrollbars=yes,resizable=yes,menubar=yes,directories=no,status=no,location=no,width=800,height=600")</xsl:if>
				<xsl:if test="$toclang = 'JAPANESE'">openNewWindow("note/note_plist_ja.html", "scrollbars=yes,resizable=yes,menubar=yes,directories=no,status=no,location=no,width=800,height=600")</xsl:if>
			</xsl:attribute>
			<xsl:attribute name="title">
				<xsl:if test="$toclang != 'JAPANESE'">Note on Using Parts List</xsl:if>
				<xsl:if test="$toclang = 'JAPANESE'">部品表使用上の注意</xsl:if>
			</xsl:attribute>
			<xsl:if test="$toclang != 'JAPANESE'">Note on Using Parts List</xsl:if>
			<xsl:if test="$toclang = 'JAPANESE'">部品表使用上の注意</xsl:if>
		</a>
	</div>
-->
	<xsl:for-each select="/JVCSM/UL/*">
		<xsl:if test="name() = 'LI'">
			<div>
				<xsl:if test="not (OBJECT/param[@name='ImageNumber']/@value != '')">
					<xsl:if test="not (OBJECT/param[@name=$Local]/@value != '')">
						<xsl:attribute name="class">ttl1</xsl:attribute>
						<xsl:call-template name="insImg"/>
					</xsl:if>
					<xsl:if test="OBJECT/param[@name=$Local]/@value != ''">
						<xsl:attribute name="class">ttl0</xsl:attribute>
					</xsl:if>
				</xsl:if>
				<xsl:call-template name="title"/>
			</div>
		</xsl:if>
		<xsl:if test="name() = 'UL'">
			<div style='display:block;'>
				<xsl:attribute name="id">
					<xsl:number level="any" count="/JVCSM/UL/LI" />
				</xsl:attribute>
				<xsl:for-each select="LI">
					<div class="ttl2"><xsl:call-template name="title"/></div>
				</xsl:for-each>
			</div>
		</xsl:if>
	</xsl:for-each>
</div>
</html>
</xsl:template>

<xsl:template name="insImg">
	<img align='absmiddle' hspace='5' onmouseover="this.style.cursor='pointer';">
		<xsl:attribute name="src">
			<xsl:value-of select="$ImgPath" />/fg1.gif
		</xsl:attribute>
		<xsl:attribute name="id">
			<xsl:variable name="num">
				<xsl:number level="any" count="/JVCSM/UL/LI" />
			</xsl:variable>
			<xsl:value-of select="concat('nd', $num)" />
		</xsl:attribute>
		<xsl:attribute name="onclick">
			ViewTree(<xsl:number level="any" count="/JVCSM/UL/LI" />);
		</xsl:attribute>
	</img>
</xsl:template>

<xsl:template name="title">
	<xsl:if test="(OBJECT/param[@name=$Local]/@value != '')">
		<xsl:if test="contains(OBJECT/param[@name=$Local]/@value, 'JavaScript:')">
			<span style="background:white">
				<xsl:attribute name="class">
					<xsl:value-of select="OBJECT/param[@name='Name']/@id" />
				</xsl:attribute>
				<a>
					<xsl:attribute name="href">
						<xsl:value-of select="OBJECT/param[@name=$Local]/@value" />
					</xsl:attribute>
					<xsl:attribute name="title">
						<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
					</xsl:attribute>
					<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
				</a>
			</span>
		</xsl:if>
		<xsl:if test="not (contains(OBJECT/param[@name=$Local]/@value, 'JavaScript:'))">
			<a>
				<xsl:attribute name="href">
					<xsl:value-of select="OBJECT/param[@name=$Local]/@value" />
				</xsl:attribute>
				<xsl:attribute name="title">
					<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
				</xsl:attribute>
				<xsl:attribute name="target">
					<xsl:value-of select="OBJECT/param[@name='FrameName']/@value" />
				</xsl:attribute>
				<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
			</a>
		</xsl:if>
	</xsl:if>
	<xsl:if test="not (OBJECT/param[@name=$Local]/@value != '')">
		<xsl:if test="$toclang != 'JAPANESE'">
			<xsl:value-of select="OBJECT/param[@name='Name']/@value" />
		</xsl:if>
		<xsl:if test="$toclang = 'JAPANESE'">
			<xsl:choose>
				<xsl:when test="OBJECT/param[@name='Name']/@value = 'Schematic Diagrams'">基準回路図</xsl:when>
				<xsl:when test="OBJECT/param[@name='Name']/@value = 'Printed Circuit Board'">基板図</xsl:when>
				<xsl:when test="OBJECT/param[@name='Name']/@value = 'Block Diagrams'">ブロックダイアグラム</xsl:when>
				<xsl:when test="OBJECT/param[@name='Name']/@value = 'Exploded View'">分解図</xsl:when>
				<xsl:when test="OBJECT/param[@name='Name']/@value = 'Description of Major ICs'">主要ICの概要</xsl:when>
			</xsl:choose>
		</xsl:if>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
